#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

#define FOND_Z 1.f

static GrVertex Fond1 = {0.f,0.f,FOND_Z,  255,0,0,   0,128.f,1.f/FOND_Z,{16,16, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   0,255,0,   0,128.f,1.f/FOND_Z,{240.f/FOND_Z,16,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   0,0,255,   0,128.f,1.f/FOND_Z,{240.f/FOND_Z,240.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   128,128,128,   0,128.f,1.f/FOND_Z,{16,240.f/FOND_Z,1.f/FOND_Z}};

static int MiniSin[256], MiniCos[256];

void LInit_Onde2()
{
	int Cpt1;

	for(Cpt1=0;Cpt1<256;Cpt1++)
	{
		MiniSin[Cpt1] = 16.f*sin(Cpt1*PI2/256.f);
		MiniCos[Cpt1] = 16.f*cos(Cpt1*PI2/256.f);
	}
}

void QInit_Onde2()
{
  grDepthBufferMode(GR_DEPTHBUFFER_DISABLE);
  grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
  grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
		 GR_COMBINE_FACTOR_ONE,
		GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
  grCullMode(GR_CULL_DISABLE);
  
  grChromakeyMode(GR_CHROMAKEY_DISABLE);
  grFogMode(GR_FOG_DISABLE);
  
  g_TextureBuff.info.format = GR_TEXFMT_RGB_565;
  SelectTexture(g_TextureBuff);
}

void Effect_Onde2()
{
	int Cpt1, Cpt2;
	WORD *pDst, *pSrc;
	float SinTmp, CosTmp;
	static float fZoom;
	float fZoomer;

	pDst = (WORD*)g_FrameBuf3d;
	//pSrc = g_PicFlo1;
	pSrc = g_PicPanneau;

	for(Cpt1=0;Cpt1<256;Cpt1++)
	{
		for(Cpt2=0;Cpt2<256;Cpt2++)
		{
			*(pDst++) = 
				pSrc[
				((Cpt1+MiniSin[(g_demostate.TickInEffect/4+Cpt1-Cpt2)&255])&255)*256
				+(Cpt2+MiniCos[(g_demostate.TickInEffect/4+Cpt1+Cpt2)&255]&255)
				];
		}
		//pDst += 16;
	}

	grTexDownloadMipMap(g_TextureBuff.tmu, g_TextureBuff.start,
						g_TextureBuff.evenOdd, &g_TextureBuff.info);

	fZoomer = 20.f+20.f*CosTable[(g_demostate.TickInEffect*4)&8191];

	Fond1.tmuvtx[0].sow = fZoomer;
	Fond1.tmuvtx[0].tow = fZoomer;
	Fond2.tmuvtx[0].sow = 256.f-fZoomer;
	Fond2.tmuvtx[0].tow = fZoomer;
	Fond3.tmuvtx[0].sow = 256.f-fZoomer;
	Fond3.tmuvtx[0].tow = 256.f-fZoomer;
	Fond4.tmuvtx[0].sow = fZoomer;
	Fond4.tmuvtx[0].tow = 256.f-fZoomer;

	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);

}

void ByeBye_Onde2()
{


}
